<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $categoryId = $_GET['categoryid'] ?? null;

    // Log session and request data for debugging
    error_log('Full Session: ' . print_r($_SESSION, true));
    error_log('Requested Category ID: ' . $categoryId);

    if ($categoryId) {
        $categoryKey = "category_" . $categoryId; 

        if (isset($_SESSION[$categoryKey])) {
            echo json_encode([
                'status' => 'success',
                'categoryId' => $categoryKey,
                'data' => $_SESSION[$categoryKey]
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'No data found for the selected category',
                'debug_session' => $_SESSION // Temporary debugging
            ]);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Category ID not provided']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
}
